<?php
header('Content-Type: application/json');
date_default_timezone_set('Asia/Jakarta');

// Konfigurasi database
$servername = "localhost"; // Server database (biasanya 'localhost' di Namecheap)
$username = "purbrzog_admin_data"; // Nama pengguna database yang Anda buat
$password = "premantuak123"; // Password pengguna database
$dbname = "purbrzog_admin_data"; // Nama database yang Anda buat

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Koneksi database gagal: ' . $e->getMessage()
    ]);
    exit;
}

// Ambil data dari POST
$id            = $_POST['id'] ?? null;
$waktuperiode  = $_POST['waktuperiode'] ?? null;
$session       = $_POST['session'] ?? null;
$angka1        = $_POST['angka1'] ?? null;
$angka2        = $_POST['angka2'] ?? null;
$angka3        = $_POST['angka3'] ?? null;

// Validasi data wajib
if (!$id || !$waktuperiode || !$session || !$angka1 || !$angka2 || !$angka3) {
    echo json_encode(['status' => 'error', 'message' => 'Data tidak lengkap']);
    exit;
}

try {
    // Update data
    $stmt = $conn->prepare("UPDATE history SET 
        tanggal_periode = :waktuperiode,
        session = :session,
        angka1 = :angka1,
        angka2 = :angka2,
        angka3 = :angka3
        WHERE id = :id");

    $stmt->bindParam(':waktuperiode', $waktuperiode);
    $stmt->bindParam(':session', $session);
    $stmt->bindParam(':angka1', $angka1);
    $stmt->bindParam(':angka2', $angka2);
    $stmt->bindParam(':angka3', $angka3);
    $stmt->bindParam(':id', $id);

    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'Data berhasil diupdate']);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Gagal mengupdate data: ' . $e->getMessage()
    ]);
}
?>
