<?php
ob_clean();
header('Content-Type: application/json');
date_default_timezone_set('Asia/Jakarta');

// Koneksi ke database
$servername = "localhost"; // Server database (biasanya 'localhost' di Namecheap)
$username = "purbrzog_admin_data"; // Nama pengguna database yang Anda buat
$password = "premantuak123"; // Password pengguna database
$dbname = "purbrzog_admin_data"; // Nama database yang Anda buat

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Koneksi database gagal: ' . $e->getMessage()
    ]);
    exit;
}

// Ambil data dari form
$tanggal_periode = $_POST['waktuperiode'] ?? '';
$session         = $_POST['session'] ?? 'Morning';
$angka1          = $_POST['angka1'] ?? '';
$angka2          = $_POST['angka2'] ?? '';
$angka3          = $_POST['angka3'] ?? '';
$tanggal_input   = date('Y-m-d');
$waktu_input     = date('H:i:s');

// Validasi input
if (empty($tanggal_periode) || empty($session) || empty($angka1) || empty($angka2) || empty($angka3)) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Data tidak lengkap atau kosong'
    ]);
    exit;
}

// Simpan ke database
try {
    $stmt = $conn->prepare("
        INSERT INTO history 
        (tanggal_periode, tanggal_input, waktu_input, session, angka1, angka2, angka3)
        VALUES 
        (:tanggal_periode, :tanggal_input, :waktu_input, :session, :angka1, :angka2, :angka3)
    ");

    $stmt->bindParam(':tanggal_periode', $tanggal_periode);
    $stmt->bindParam(':tanggal_input', $tanggal_input);
    $stmt->bindParam(':waktu_input', $waktu_input);
    $stmt->bindParam(':session', $session);
    $stmt->bindParam(':angka1', $angka1);
    $stmt->bindParam(':angka2', $angka2);
    $stmt->bindParam(':angka3', $angka3);
    $stmt->execute();

    echo json_encode([
        'status'  => 'success',
        'message' => 'Data berhasil disimpan'
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Gagal menyimpan data: ' . $e->getMessage()
    ]);
}
?>
